<?php $__env->startSection('title', 'Dashboard Absensi'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', sans-serif;
    }

    body {
        margin: 0;
        padding: 0;
        background: #ffffff;
        overflow: hidden;
    }

    .fullscreen-wrapper {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        display: flex;
        flex-direction: column;
        background: #f8f9fa;
    }

    /* Scrollable Content */
    .dashboard-content {
    /* margin-top: 70px; */
        flex: 1;
        overflow-y: auto;
        -webkit-overflow-scrolling: touch;
        scroll-behavior: smooth;
    }

    /* Alert Messages */
    .alert-container {
        padding: 15px 20px;
        background: white;
        flex-shrink: 0;
    }

    .alert {
        padding: 12px 15px;
        border-radius: 8px;
        font-size: 14px;
        display: flex;
        align-items: center;
        gap: 10px;
        margin-bottom: 10px;
    }

    .alert:last-child {
        margin-bottom: 0;
    }

    .alert-success {
        background: #d4edda;
        color: #155724;
        border-left: 4px solid #28a745;
    }

    .alert-danger {
        background: #f8d7da;
        color: #721c24;
        border-left: 4px solid #dc3545;
    }

    .alert-info {
        background: #d1ecf1;
        color: #0c5460;
        border-left: 4px solid #17a2b8;
    }

    /* Blue Header Section */
    .blue-header {
        margin-top: 80px;
        /* background: linear-gradient(135deg, #4285f4 0%, #5a98f7 100%); */
        background: #354591;
        padding: 20px;
        color: white;
    }

    .welcome-text {
        font-size: 24px;
        font-weight: 700;
        margin: 0;
    }

    /* Main White Card */
    .main-card {
        background: white;
        border-radius: 25px 25px 0 0;
        margin-top: -20px;
        padding: 25px 20px;
        position: relative;
        z-index: 1;
    }

    /* Shift Info - Inline Display */
.shift-info.shift-inline {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 24px;
    margin: 12px 16px 20px;
    font-size: 14px;
    color: #444;
}

.shift-item {
    display: flex;
    align-items: center;
    gap: 6px;
    font-weight: 500;
}

.shift-item i {
    font-size: 13px;
    color: #3b6ef5;
}

/* Divider tipis */
.shift-divider {
    width: 1px;
    height: 16px;
    background: #ddd;
}

.shift-item:first-child span {
    background: #eef4ff;
    padding: 4px 10px;
    border-radius: 999px;
    font-weight: 600;
    color: #3b6ef5;
}

    .shift-row {
        display: flex;
        align-items: center;
        gap: 15px;
        margin-bottom: 10px;
    }

    .shift-row:last-child {
        margin-bottom: 0;
    }

    .shift-icon {
        width: 40px;
        height: 40px;
        background: linear-gradient(135deg, #4285f4 0%, #5a98f7 100%);
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 18px;
        flex-shrink: 0;
    }

    .shift-details {
        flex: 1;
    }

    .shift-label {
        font-size: 12px;
        color: #666;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 3px;
    }

    .shift-value {
        font-size: 16px;
        color: #1a1a1a;
        font-weight: 700;
    }

    /* Clock & Check Button Section */
    .clock-section {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 25px;
        gap: 20px;
    }

    .clock-info {
        flex: 1;
    }

    .current-time {
        font-size: 32px;
        font-weight: 700;
        color: #1a1a1a;
        margin-bottom: 5px;
        font-variant-numeric: tabular-nums;
        letter-spacing: -0.5px;
    }

    .current-date {
        font-size: 13px;
        color: #666;
        font-weight: 600;
        text-transform: uppercase;
    }

    .check-btn {
        background: #4285f4;
        color: white;
        border: none;
        padding: 14px 35px;
        border-radius: 25px;
        font-size: 15px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s;
        box-shadow: 0 4px 15px rgba(66, 133, 244, 0.3);
        white-space: nowrap;
        flex-shrink: 0;
    }

    .check-btn:hover:not(:disabled) {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(66, 133, 244, 0.4);
    }

    .check-btn:active:not(:disabled) {
        transform: translateY(0);
    }

    .check-btn:disabled {
        background: #e0e0e0;
        color: #999;
        cursor: not-allowed;
        box-shadow: none;
    }

    /* Time Stats Grid */
    .time-stats {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 15px;
        margin-bottom: 0;
    }

    .time-stat-item {
        text-align: center;
        background: #f8f9fa;
        padding: 18px 10px;
        border-radius: 15px;
    }

    .stat-icon {
        width: 45px;
        height: 45px;
        background: linear-gradient(135deg, #4285f4 0%, #5a98f7 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 12px;
        color: white;
        font-size: 20px;
    }

    .stat-time {
        font-size: 18px;
        font-weight: 700;
        color: #1a1a1a;
        margin-bottom: 5px;
        font-variant-numeric: tabular-nums;
    }

    .stat-label {
        font-size: 13px;
        color: #666;
        font-weight: 500;
    }

    /* Attendance Section */
    .attendance-section {
        background: white;
        padding: 25px 20px 100px;
        /* Extra padding untuk bottom nav */
        margin-top: 15px;
    }

    .attendance-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .attendance-title {
        font-size: 18px;
        font-weight: 700;
        color: #1a1a1a;
        margin: 0;
    }

    .month-badge {
        background: #e8f2ff;
        color: #4285f4;
        padding: 8px 16px;
        border-radius: 20px;
        font-size: 13px;
        font-weight: 700;
        display: flex;
        align-items: center;
        gap: 8px;
        border: 2px solid #4285f4;
        cursor: pointer;
        transition: all 0.3s;
    }

    .month-badge:hover {
        background: #4285f4;
        color: white;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(66, 133, 244, 0.3);
    }

    .month-badge:active {
        transform: translateY(0);
    }

    .month-badge i {
        font-size: 14px;
    }

    /* Stats Cards */
    .stats-cards {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 12px;
        margin-bottom: 25px;
    }

    .stat-card {
        background: #f8f9fa;
        border-radius: 15px;
        padding: 20px 15px;
        text-align: center;
        position: relative;
        overflow: hidden;
    }

    .stat-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 5px;
    }

    .stat-card.present::before {
        background: linear-gradient(90deg, #10b981, #059669);
    }

    .stat-card.absent::before {
        background: linear-gradient(90deg, #ef4444, #dc2626);
    }

    .stat-card.late::before {
        background: linear-gradient(90deg, #f59e0b, #d97706);
    }

    .stat-card-label {
        font-size: 14px;
        color: #666;
        margin-bottom: 10px;
        font-weight: 600;
    }

    .stat-card-value {
        font-size: 40px;
        font-weight: 700;
        line-height: 1;
        font-variant-numeric: tabular-nums;
    }

    .stat-card.present .stat-card-value {
        color: #10b981;
    }

    .stat-card.absent .stat-card-value {
        color: #ef4444;
    }

    .stat-card.late .stat-card-value {
        color: #f59e0b;
    }

    /* Request Button */
    .request-btn {
        width: 100%;
        background: white;
        border: 2px solid #4285f4;
        color: #4285f4;
        padding: 14px;
        border-radius: 30px;
        font-size: 15px;
        font-weight: 700;
        cursor: pointer;
        transition: all 0.3s;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
    }

    .request-btn:hover {
        background: #4285f4;
        color: white;
        transform: translateY(-2px);
        box-shadow: 0 4px 15px rgba(66, 133, 244, 0.3);
    }

    .request-btn:active {
        transform: translateY(0);
    }

    .request-btn i {
        font-size: 18px;
    }

    /* Pull to Refresh Indicator */
    .pull-refresh {
        position: absolute;
        top: 0;
        left: 50%;
        transform: translateX(-50%) translateY(-50px);
        background: white;
        padding: 10px 20px;
        border-radius: 20px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        font-size: 14px;
        color: #4285f4;
        font-weight: 600;
        opacity: 0;
        transition: all 0.3s;
        z-index: 1000;
    }

    .pull-refresh.show {
        opacity: 1;
        transform: translateX(-50%) translateY(10px);
    }

    /* Responsive */
    @media (max-width: 768px) {
        .blue-header {
            padding: 15px;
        }

        .welcome-text {
            font-size: 20px;
        }

        .main-card {
            padding: 20px 15px;
            margin-top: -15px;
        }

        .current-time {
            font-size: 28px;
        }

        .check-btn {
            padding: 12px 28px;
            font-size: 14px;
        }

        .stat-icon {
            width: 40px;
            height: 40px;
            font-size: 18px;
        }

        .stat-time {
            font-size: 16px;
        }

        .stat-card-value {
            font-size: 36px;
        }

        .attendance-section {
            padding: 20px 15px 100px;
        }
    }

    @media (max-width: 640px) {
        .clock-section {
            flex-direction: column;
            align-items: stretch;
            gap: 15px;
        }

        .clock-info {
            text-align: center;
        }

        .check-btn {
            width: 100%;
            padding: 13px;
        }

        .shift-row {
            flex-direction: column;
            align-items: flex-start;
            gap: 10px;
        }

        .shift-icon {
            align-self: flex-start;
        }
    }

    @media (max-width: 480px) {
        .welcome-text {
            font-size: 18px;
        }

        .current-time {
            font-size: 24px;
        }

        .time-stats {
            gap: 10px;
        }

        .time-stat-item {
            padding: 15px 8px;
        }

        .stat-icon {
            width: 38px;
            height: 38px;
            font-size: 16px;
            margin-bottom: 10px;
        }

        .stat-time {
            font-size: 15px;
        }

        .stat-label {
            font-size: 12px;
        }

        .stat-card {
            padding: 15px 10px;
        }

        .stat-card-value {
            font-size: 32px;
        }

        .stat-card-label {
            font-size: 13px;
        }

        .attendance-title {
            font-size: 16px;
        }

        .month-badge {
            font-size: 12px;
            padding: 6px 12px;
        }

        .shift-info {
            padding: 12px;
        }

        .shift-icon {
            width: 36px;
            height: 36px;
            font-size: 16px;
        }

        .shift-value {
            font-size: 15px;
        }

            /* ========== TAMBAHAN: MINI CALENDAR ========== */
    .mini-calendar-section {
        background: white;
        padding: 0 20px 25px;
    }

    .calendar-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 15px;
    }

    .calendar-title {
        font-size: 16px;
        font-weight: 700;
        color: #1a1a1a;
    }

    .calendar-nav {
        display: flex;
        gap: 10px;
    }

    .calendar-nav-btn {
        width: 32px;
        height: 32px;
        border-radius: 8px;
        background: #f8f9fa;
        border: none;
        color: #4285f4;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.2s;
    }

    .calendar-nav-btn:hover {
        background: #e8f2ff;
    }

    .calendar-grid {
        display: grid;
        grid-template-columns: repeat(7, 1fr);
        gap: 4px;
        margin-bottom: 15px;
    }

    .calendar-day-header {
        text-align: center;
        font-size: 11px;
        font-weight: 600;
        color: #666;
        padding: 8px 4px;
        text-transform: uppercase;
    }

    .calendar-day {
        aspect-ratio: 1;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 13px;
        font-weight: 600;
        border-radius: 8px;
        position: relative;
        cursor: pointer;
        transition: all 0.2s;
    }

    .calendar-day:hover {
        background: #f8f9fa;
    }

    .calendar-day.empty {
        cursor: default;
        pointer-events: none;
    }

    .calendar-day.today {
        background: #4285f4;
        color: white;
    }

    .calendar-day.hadir {
        background: #d1fae5;
        color: #059669;
    }

    .calendar-day.terlambat {
        background: #fef3c7;
        color: #d97706;
    }

    .calendar-day.alpa {
        background: #fee2e2;
        color: #dc2626;
    }

    .calendar-day.cuti {
        background: #e0e7ff;
        color: #6366f1;
    }

    .calendar-day.libur {
        background: #f3f4f6;
        color: #9ca3af;
    }

    .calendar-day.sakit, .calendar-day.izin {
        background: #fed7aa;
        color: #ea580c;
    }

    .calendar-legend {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 8px;
        margin-bottom: 20px;
    }

    .legend-item {
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 12px;
        color: #666;
    }

    .legend-color {
        width: 16px;
        height: 16px;
        border-radius: 4px;
    }

    .legend-color.hadir { background: #d1fae5; }
    .legend-color.terlambat { background: #fef3c7; }
    .legend-color.alpa { background: #fee2e2; }
    .legend-color.cuti { background: #e0e7ff; }
    .legend-color.libur { background: #f3f4f6; }
    .legend-color.sakit { background: #fed7aa; }

    @media (max-width: 640px) {
        .calendar-legend {
            grid-template-columns: 1fr;
        }
    }

    @media (max-width: 480px) {
        .calendar-day {
            font-size: 12px;
        }

        .calendar-day-header {
            font-size: 10px;
            padding: 6px 2px;
        }
    }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="fullscreen-wrapper">
    <!-- Alert Messages -->
    <?php if(session('success') || session('error') || session('info')): ?>
    <div class="alert-container">
        <?php if(session('success')): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            <span><?php echo e(session('success')); ?></span>
        </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
        <div class="alert alert-danger">
            <i class="fas fa-exclamation-circle"></i>
            <span><?php echo e(session('error')); ?></span>
        </div>
        <?php endif; ?>

        <?php if(session('info')): ?>
        <div class="alert alert-info">
            <i class="fas fa-info-circle"></i>
            <span><?php echo e(session('info')); ?></span>
        </div>
        <?php endif; ?>
    </div>
    <?php endif; ?>

    <!-- Scrollable Content -->
    <div class="dashboard-content" id="dashboardContent">
        <div class="pull-refresh" id="pullRefresh">
            <i class="fas fa-sync-alt"></i> Pull to refresh
        </div>

        <!-- Blue Header -->
        <div class="blue-header">
            
        </div>

        <!-- Main White Card -->
        <div class="main-card">
            <!-- Shift Info - Inline Display -->
<!-- Shift Info - Inline Display -->
<div class="shift-info shift-inline">
    <div class="shift-item">
        <i class="fas fa-briefcase"></i>
        <span><?php echo e($shift ?? 'Belum Ditentukan'); ?></span>
    </div>

    <div class="shift-divider"></div>

    <div class="shift-item">
        <i class="fas fa-clock"></i>
        <span><?php echo e($jamMasuk ?? '--:--'); ?> - <?php echo e($jamPulang ?? '--:--'); ?></span>
    </div>
</div>


            <!-- Clock & Check Button -->
            <div class="clock-section">
                <div class="clock-info">
                    <div class="current-time" id="live-clock">00:00:00</div>
                    <div class="current-date"><?php echo e(strtoupper(\Carbon\Carbon::now()->translatedFormat('l, d F Y'))); ?></div>
                </div>

                <?php if($absensiToday && $absensiToday->jam_masuk && !$absensiToday->jam_pulang): ?>
                    <button class="check-btn" onclick="window.location.href='<?php echo e(route('karyawan.absensi.pulang.form')); ?>'">
                        Check Out
                    </button>
                <?php elseif($absensiToday && $absensiToday->jam_pulang): ?>
                    <button class="check-btn" disabled>
                        Completed
                    </button>
                <?php else: ?>
                    <button class="check-btn" onclick="window.location.href='<?php echo e(route('karyawan.absensi.masuk.form')); ?>'">
                        Check In
                    </button>
                <?php endif; ?>
            </div>

            <!-- Time Stats -->
            <div class="time-stats">
                <div class="time-stat-item">
                    <div class="stat-icon">
                        <i class="fas fa-sign-in-alt"></i>
                    </div>
                    <div class="stat-time">
                        <?php if($absensiToday && $absensiToday->jam_masuk): ?>
                            <?php echo e(date('H:i', strtotime($absensiToday->jam_masuk))); ?>

                        <?php else: ?>
                            --:--
                        <?php endif; ?>
                    </div>
                    <div class="stat-label">Check In</div>
                </div>

                <div class="time-stat-item">
                    <div class="stat-icon">
                        <i class="fas fa-sign-out-alt"></i>
                    </div>
                    <div class="stat-time">
                        <?php if($absensiToday && $absensiToday->jam_pulang): ?>
                            <?php echo e(date('H:i', strtotime($absensiToday->jam_pulang))); ?>

                        <?php else: ?>
                            --:--
                        <?php endif; ?>
                    </div>
                    <div class="stat-label">Check Out</div>
                </div>

                <div class="time-stat-item">
                    <div class="stat-icon">
                        <i class="fas fa-hourglass-half"></i>
                    </div>
                    <div class="stat-time">
                        <?php if($absensiToday && $absensiToday->jam_masuk && $absensiToday->jam_pulang): ?>
                            <?php
                                $masuk = \Carbon\Carbon::parse($absensiToday->jam_masuk);
                                $pulang = \Carbon\Carbon::parse($absensiToday->jam_pulang);
                                $diff = $pulang->diff($masuk);
                                $hours = $diff->h + ($diff->days * 24);
                            ?>
                            <?php echo e(sprintf('%02d:%02d', $hours, $diff->i)); ?>

                        <?php else: ?>
                            00:00
                        <?php endif; ?>
                    </div>
                    <div class="stat-label">Working HR's</div>
                </div>
            </div>
        </div>

        <!-- Attendance Section -->
        <div class="attendance-section">
            <div class="attendance-header">
                <h3 class="attendance-title">Attendance for this Month</h3>
                <div class="month-badge" onclick="window.location.href='<?php echo e(route('karyawan.absensi.log')); ?>'">
                    <?php echo e(strtoupper(\Carbon\Carbon::now()->translatedFormat('F'))); ?>

                    <i class="fas fa-chevron-right"></i>
                </div>
            </div>

            <div class="stats-cards">
                <div class="stat-card present">
                    <div class="stat-card-label">Present</div>
                    <div class="stat-card-value"><?php echo e($stats['hadir'] ?? 0); ?></div>
                </div>

                <div class="stat-card absent">
                    <div class="stat-card-label">Absents</div>
                    <div class="stat-card-value"><?php echo e(str_pad($stats['alpa'] ?? 0, 2, '0', STR_PAD_LEFT)); ?></div>
                </div>

                <div class="stat-card late">
                    <div class="stat-card-label">Late in</div>
                    <div class="stat-card-value"><?php echo e(str_pad($stats['terlambat'] ?? 0, 2, '0', STR_PAD_LEFT)); ?></div>
                </div>
            </div>
<!-- Mini Calendar Section (BARU) -->
<div class="mini-calendar-section">
    <div class="calendar-header">
        <h3 class="calendar-title" id="calendarMonth"><?php echo e(\Carbon\Carbon::now()->translatedFormat('F Y')); ?></h3>
        <div class="calendar-nav">
            <button class="calendar-nav-btn" onclick="changeMonth(-1)">
                <i class="fas fa-chevron-left"></i>
            </button>
            <button class="calendar-nav-btn" onclick="changeMonth(1)">
                <i class="fas fa-chevron-right"></i>
            </button>
        </div>
    </div>

    <div class="calendar-grid" id="calendarGrid">
        <!-- Calendar generated by JavaScript -->
    </div>

    <div class="calendar-legend">
        <div class="legend-item">
            <div class="legend-color hadir"></div>
            <span>Hadir</span>
        </div>
        <div class="legend-item">
            <div class="legend-color terlambat"></div>
            <span>Terlambat</span>
        </div>
        <div class="legend-item">
            <div class="legend-color alpa"></div>
            <span>Alpa</span>
        </div>
        <div class="legend-item">
            <div class="legend-color cuti"></div>
            <span>Cuti</span>
        </div>
        <div class="legend-item">
            <div class="legend-color sakit"></div>
            <span>Sakit/Izin</span>
        </div>
        <div class="legend-item">
            <div class="legend-color libur"></div>
            <span>Libur</span>
        </div>
    </div>

    
            <button class="request-btn" onclick="window.location.href='<?php echo e(route('karyawan.pengajuan.index')); ?>'">
                <i class="fas fa-plus"></i>
                Request
            </button>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    const attendanceData = <?php echo json_encode($calendarData ?? [], 15, 512) ?>;
let currentMonth = new Date().getMonth();
let currentYear = new Date().getFullYear();

// Live Clock
function updateClock() {
    const now = new Date();
    const hours = String(now.getHours()).padStart(2, '0');
    const minutes = String(now.getMinutes()).padStart(2, '0');
    const seconds = String(now.getSeconds()).padStart(2, '0');
    document.getElementById('live-clock').textContent = `${hours}:${minutes}:${seconds}`;
}

setInterval(updateClock, 1000);
updateClock();

// Generate Calendar
function generateCalendar(month, year) {
    const grid = document.getElementById('calendarGrid');
    const monthTitle = document.getElementById('calendarMonth');

    const monthNames = ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
                        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];
    monthTitle.textContent = `${monthNames[month]} ${year}`;

    grid.innerHTML = '';

    // Day headers
    const dayHeaders = ['Min', 'Sen', 'Sel', 'Rab', 'Kam', 'Jum', 'Sab'];
    dayHeaders.forEach(day => {
        const header = document.createElement('div');
        header.className = 'calendar-day-header';
        header.textContent = day;
        grid.appendChild(header);
    });

    const firstDay = new Date(year, month, 1).getDay();
    const daysInMonth = new Date(year, month + 1, 0).getDate();
    const today = new Date();

    // Empty cells
    for (let i = 0; i < firstDay; i++) {
        const emptyDay = document.createElement('div');
        emptyDay.className = 'calendar-day empty';
        grid.appendChild(emptyDay);
    }

    // Days
    for (let day = 1; day <= daysInMonth; day++) {
        const dayCell = document.createElement('div');
        dayCell.className = 'calendar-day';
        dayCell.textContent = day;

        if (day === today.getDate() && month === today.getMonth() && year === today.getFullYear()) {
            dayCell.classList.add('today');
        }

        const dateStr = `${year}-${String(month + 1).padStart(2, '0')}-${String(day).padStart(2, '0')}`;
        if (attendanceData[dateStr]) {
            dayCell.classList.add(attendanceData[dateStr].toLowerCase());
        }

        grid.appendChild(dayCell);
    }
}

function changeMonth(direction) {
    currentMonth += direction;
    if (currentMonth > 11) {
        currentMonth = 0;
        currentYear++;
    } else if (currentMonth < 0) {
        currentMonth = 11;
        currentYear--;
    }
    generateCalendar(currentMonth, currentYear);
}

document.addEventListener('DOMContentLoaded', function() {
    generateCalendar(currentMonth, currentYear);
});
// Live Clock dengan format Indonesia (24 jam)
function updateClock() {
    const now = new Date();
    const hours = String(now.getHours()).padStart(2, '0');
    const minutes = String(now.getMinutes()).padStart(2, '0');
    const seconds = String(now.getSeconds()).padStart(2, '0');

    const timeString = `${hours}:${minutes}:${seconds}`;

    const clockElement = document.getElementById('live-clock');
    if (clockElement) {
        clockElement.textContent = timeString;
    }
}

// Update clock every second
setInterval(updateClock, 1000);
updateClock();

// Pull to Refresh
let startY = 0;
let pullDistance = 0;
const dashboardContent = document.getElementById('dashboardContent');
const pullRefresh = document.getElementById('pullRefresh');

dashboardContent.addEventListener('touchstart', (e) => {
    if (dashboardContent.scrollTop === 0) {
        startY = e.touches[0].pageY;
    }
});

dashboardContent.addEventListener('touchmove', (e) => {
    if (dashboardContent.scrollTop === 0) {
        const currentY = e.touches[0].pageY;
        pullDistance = currentY - startY;

        if (pullDistance > 0 && pullDistance < 100) {
            pullRefresh.classList.add('show');
        }
    }
});

dashboardContent.addEventListener('touchend', () => {
    if (pullDistance > 80) {
        // Reload page
        location.reload();
    }
    pullRefresh.classList.remove('show');
    pullDistance = 0;
});

// Auto-hide alerts after 4 seconds
document.addEventListener('DOMContentLoaded', function() {
    setTimeout(() => {
        const alertContainer = document.querySelector('.alert-container');
        if (alertContainer) {
            alertContainer.style.transition = 'opacity 0.3s';
            alertContainer.style.opacity = '0';
            setTimeout(() => alertContainer.remove(), 300);
        }
    }, 4000);

    // Touch feedback for mobile
    const buttons = document.querySelectorAll('.check-btn, .request-btn, .month-badge');
    buttons.forEach(button => {
        button.addEventListener('touchstart', () => {
            if (!button.disabled) {
                button.style.transform = button.classList.contains('month-badge')
                    ? 'scale(0.95)'
                    : 'scale(0.98)';
            }
        });
        button.addEventListener('touchend', () => {
            button.style.transform = '';
        });
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('karyawan.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\DAVA\Documents\FILE_SEKOLAH\WEB XII\absensi-hotel - Copy\resources\views/karyawan/dashboard.blade.php ENDPATH**/ ?>